function autoSizePanels() 
{
    var agt = navigator.userAgent.toLowerCase();
    var is_iemac = agt.indexOf("mac") != -1 && agt.indexOf("msie") && -1;
    var adjust = getHeightAdjustment();
    var winheight;

    var bodywidth;
    var bodyheight;

    if (window.document.compatMode && window.document.compatMode != 'BackCompat')
    {
        bodywidth = window.document.documentElement.offsetWidth;
        bodyheight = window.document.documentElement.offsetHeight;
    }
    else
    {
        if (window.event)
        {
            bodywidth = window.document.body.offsetWidth;
            bodyheight = window.document.body.offsetHeight;
        }
        else
        {
            bodywidth = window.innerWidth;
            bodyheight = window.innerHeight || document.documentElement.offsetHeight;
        }
    }


    if (is_iemac)
    {
        winheight = window.document.body.scrollHeight;
        adjust += 80;
    }
    else
    {
        winheight = bodyheight;
        adjust += 40;
    }

    // consider also the page header height when screen templates are used
    var trPageHeaderRow = document.getElementById("PageHeaderRow");
    if (trPageHeaderRow != null) {
      adjust += trPageHeaderRow.firstChild.clientHeight;
    }


    if (bodywidth - 50 > 0)
    {
        document.getElementById('MainVCCTable').style.width = bodywidth - 50 + 'px';
    }


    if (document.getElementById('USESINGLEPANELFORTTEMPLATE') && document.getElementById('USESINGLEPANELFORTTEMPLATE').value == '1')
    {
        // Keep the old height ajustments for screen template
        if ((winheight - adjust) > 0) {
            document.getElementById('QuestionChoices').style.height = (winheight - adjust) + 'px';
        }
        document.getElementById('QuestionChoices').style.width = bodywidth - 50 + 'px';
        document.getElementById('AliasCell').style.width = document.getElementById('INPUTLEFTCELL').style.width;
    }
    else
    {
        var choiceswidth = (bodywidth - (bodywidth / 2.5) - 50);

        adjustQuestionsAreaHeights();

        document.getElementById('AliasCell').style.width = document.getElementById('QuestionTextTD').style.width;
        document.getElementById('MessageCell').style.width = document.getElementById('QuestionChoicesTD').style.width;
    }

    if (document.getElementById('INPUTLEFTCELL'))
    {
        document.getElementById('INPUTLEFTCELL').style.width = (bodywidth / 2.5) + 'px';
    }

    document.getElementById('AliasMsgTable').style.width = document.getElementById('MainVCCTable').style.width;

    if (document.getElementById('InputTable'))
    {
        document.getElementById('InputTable').style.width = document.getElementById('MainVCCTable').style.width;
    }

    if (document.getElementById('LONGTABLEIFRAME'))
    {
        document.getElementById('LONGTABLEIFRAME').style.width = '100%';
    }

   if (!(typeof document.documentMode === 'undefined'))
   {
       // IE scrolls to the bottom of the page with long question areas!!! Scroll back to the top left corner
       if (document.documentMode == 11)
       {
           window.scroll(0, 0);
       }
   }
} // autoSizePanels()


function adjustQuestionsAreaHeights() {
    var trPageHeaderRow = document.getElementById("PageHeaderRow");
    var hPageHeaderRow = 0;
    if (trPageHeaderRow != null) {
        hPageHeaderRow = trPageHeaderRow.firstChild.clientHeight;
    }
    var trPageFooterRow = document.getElementById("PageFooterRow");
    var hPageFooterRow = 0;
    if (trPageFooterRow != null) {
        hPageFooterRow = trPageFooterRow.firstChild.clientHeight;
    }
    var tableProgressBar = document.getElementById("ProgressBar");
    var hProgressBar = 0;
    if (tableProgressBar != null) {
        hProgressBar = 50; //enclosing TD forces at 50px tableProgressBar.clientHeight;
    }
    var tableNavigationBar = document.getElementById("NavigationBar");
    var hNavigationBar = 0;
    if (tableNavigationBar != null) {
        hNavigationBar = tableNavigationBar.clientHeight;
    }
    var tableAliasMsg = document.getElementById("AliasMsgTable");
    var hAliasMsg = 0;
    if (tableAliasMsg != null) {
        hAliasMsg = tableAliasMsg.clientHeight;
    }
    var tdInputLeftCell = document.getElementById("INPUTLEFTCELL");
    var hInputLeftCell = 0;
    if (tdInputLeftCell != null) {
        hInputLeftCell = tdInputLeftCell.clientHeight;
    }
    var marqueeArray = document.getElementsByTagName("marquee");
    var hTestMarquee = 0;
    if ((marqueeArray != null) && (marqueeArray.length > 0)) {
      hTestMarquee = marqueeArray[0].clientHeight; // there is only one marquee, and in test mode
    }
    var hBody = window.innerHeight || document.documentElement.offsetHeight;
    var hQuestionTextAndChoices = hBody - hPageHeaderRow - hPageFooterRow - hProgressBar - hNavigationBar - hAliasMsg - hInputLeftCell - hTestMarquee - 40;
    if (hQuestionTextAndChoices < 75) {
        hQuestionTextAndChoices = 75; // leave space to show about three lines of text
    }
    var tblMainVCCTable = document.getElementById("MainVCCTable");
    tblMainVCCTable.style.height = hQuestionTextAndChoices + 'px';
    // the following is required when IE is not running in Quircks mode
    tblMainVCCTable.height = hQuestionTextAndChoices + 'px';

    document.getElementById('QuestionTextTD').style.height = hQuestionTextAndChoices + 'px';
    document.getElementById('QuestionChoicesTD').style.height = hQuestionTextAndChoices + 'px';
    if (document.getElementById("LONGTABLEIFRAME")) {
      // Check if there are other question choices above the long table
      var parentDiv = document.getElementById('Div2');
      var otherChoicesHeight = 0;
      var tmpChild = parentDiv.firstChild;
      while (tmpChild != null)
      {
         if (tmpChild.nodeName == "TABLE")
         {
           otherChoicesHeight = tmpChild.clientHeight + 10;
           break;
         }
         tmpChild = tmpChild.nextSibling;
      }
      document.getElementById("LONGTABLEIFRAME").style.height = (hQuestionTextAndChoices - otherChoicesHeight) + 'px';
    }
}



function autoFocus_onLoad(controlID)
{
    if (controlID != '')
    {
        if (!document.forms[0][controlID].disabled)
        {
            document.forms[0][controlID].focus();
        }
    }
    else
    {
        focusFirstControl();
    }

    if (getBrowseMode() == '0')
    {
        setBrowseMode('0');
    }
    else
    {
        setBrowseMode('1');
    }

    autoSizePanels();
}


function CheckKeys(e)
{
	var SingleCodes = [116,117,122];             // F5, F6, F11
	var CtrlCodes =   [9,69,72,73,76,78,79,82,87];  // Tab,e,h,i,l,n,o,r,w
	var AltCodes =    [36,37,39];                // Home, left arrow, right arrow   	
	var keycode;
	var ctrlKey;
	var altKey;
	var srcEl = GetEventSource(e);
	
	// compatibility IE & Firefox
	if(window.event)
	{
		keycode = window.event.keyCode;	
		ctrlKey = window.event.ctrlKey;
		altKey = window.event.altKey;
	}
	else if (e)
	{
		keycode = e.which;
		ctrlKey = e.ctrlKey;
		altKey = e.altKey;
	}   	

   if( keycode == 27 )
   {
      return true;
   }
   
   if( keycode == 13)
   {
		if(getBrowseMode() == '0')
		{
			SubmitOnEnter(e);
		}
		else
		{			
			if(FindElementByName('NAV_QUIT'))
			{				
				FindElementByName('NAV_QUIT').click();
			}
		}		
		return false;
	}

   if( keycode == 38 || keycode == 40)
   {  
      if( srcEl.type == 'checkbox')
      {  

        var coll;
	if (document.all)
   	coll = document.all;   // IE < 6
	else
	coll = document.getElementsByTagName('*');  // DOM

        if (keycode == 40)
        {
	for(var i=coll.length -1; i >= 0; i--) {
   	   if (coll[i] == srcEl)
           {
              var index = i+1;
	      while (coll[index] != null && coll[index].type != 'checkbox') index++;	
              var next = coll[index]; 
              
              if (next != null && !next.disabled)
              {	
                 next.focus();
                 next.select(); 		 
              } 
               return false; 
               
           }
        }

	}
	else
	{
	for(var i=0; i < coll.length; i++) {
   	   if (coll[i] == srcEl)
           {
              var index = i-1;
	      while (coll[index] != null && coll[index].type != 'checkbox') index--;	
              var next = coll[index]; 
              
              if (next != null && !next.disabled)
              {
                 next.focus();
                 next.select(); 
              } 
               return false; 
               
           }
        }

	}
	         
	 
      }
      else	
      return true;
   }


   // Backspace must be disabled only when not in a form element
   if( keycode == 8 )    // Tab
   {
      if( (srcEl.type == 'text' && !srcEl.readOnly) || srcEl.type == 'textarea')
      { 
         
         return true;
      }

		CancelKeyEvent(e);
		return false;
   }

   for( var i=0; i < SingleCodes.length; i++ ) // Cancel F5, F6, F11
   {
      if( keycode == SingleCodes[i] )
      {	 
		CancelKeyEvent(e);
		return false;
      }
   }

   for( var i=0; i < CtrlCodes.length; i++ )
   {
      if( (keycode == CtrlCodes[i]) && ctrlKey && !altKey)
      {
		CancelKeyEvent(e);
		return false;
      }
   }

   for( var i=0; i < AltCodes.length; i++ )
   {
      if( (keycode == AltCodes[i]) && altKey )
      {
         alert('This Alt key is disabled');  // does not work without this line
         CancelKeyEvent(e);
         return false;
      }
   }

   return true;
}

function ProcessKey(keycode)
{
   //alert(keyCode);
 //Trap Escape key
  if (keycode == 27)	
 {    
    if (getBrowseMode()=='1')
    {       
       setBrowseMode('0');       
    }
    else
    {
       setBrowseMode('1');              
    }
    focusFirstControl();
 }
 else //PageUp
 if (keycode == 33)	
 {    
    if (getBrowseMode()=='1')
    {     
       if (!currentQuestionIsFirst())
       {
           if (document.getElementById('NAV_GOBACK') && !document.getElementById('NAV_GOBACK').disabled) {
               document.getElementById('NAV_GOBACK').click();
               document.getElementById('NAV_GOBACK').disabled = true;
           }
       }
       else
       if (FindElementByName('GOTOQ'))	 
          FindElementByName('GOTOQ').value = FindElementByName('QLABEL').value;
    }    
 }
 else //PageDown
 if (keycode == 34)	
 {    
    if (getBrowseMode()=='1')
    {
      if (!currentQuestionIsLast())
      { 
          if (document.getElementById('NAV_BROWSENEXT') && !document.getElementById('NAV_BROWSENEXT').disabled) {
              document.getElementById('NAV_BROWSENEXT').click();
              document.getElementById('NAV_BROWSENEXT').disabled = true;
          }
      }
      else
      if (FindElementByName('GOTOQ'))
         FindElementByName('GOTOQ').value = FindElementByName('QLABEL').value;
    }    
 }
 else //Home
 if (keycode == 36)	
 {    
    if (getBrowseMode()=='1')
    {       
        if (!currentQuestionIsFirst())
        {
           if (FindElementByName('GOTOQ')) 
           {
              FindElementByName('GOTOQ').selectedIndex = FindElementByName('GOTOQ').length-1;
              document.getElementById('NAV_GOTOQ').click();             
            }
        }
        else
        if (FindElementByName('GOTOQ'))
           FindElementByName('GOTOQ').value = FindElementByName('QLABEL').value;
    }    
 }
else //End
 if (keycode == 35)	
 {    
    if (getBrowseMode()=='1')
    {  				
       if (!currentQuestionIsLast())
       {		
          if (FindElementByName('GOTOQ')) 
          { 			
             FindElementByName('GOTOQ').selectedIndex = FindElementByName('GOTOQ')[0];
             document.getElementById('NAV_GOTOQ').click();      
          }  
       }
       else if (FindElementByName('GOTOQ'))
       {       
          FindElementByName('GOTOQ').value = FindElementByName('QLABEL').value;
        }
    }    
 }

}

function PageKeyPress(e)
{
	if(window.event)
	{
		var keycode = window.event.keyCode;
	}
	else
	{
		var keycode = e.which;
	}
	
	ProcessKey(keycode)	
  
}

function getFirstInputControl()
{

 var firstInput = null;
 for (var i=0;i<document.forms[0].elements.length;i++)
 {
	if (document.forms[0].elements[i].type == 'text')
	{		
	   return document.forms[0].elements[i];
	}
 }
 return null;
}

function QuestionListKeyDown(e)
{	
	var keycode;
	if(window.event)
	{
		keycode = window.event.keyCode;			
	}
	else if (e)
	{
		keycode = e.which;				
	}   
		
	if (keycode == 13 && !document.getElementById('NAV_GOTOQ').disabled) 
	{
		document.getElementById('NAV_GOTOQ').click();        
	}
  
}

function setInputControlsState(disabled)
{

 var ltiframe = document.getElementById("LONGTABLEIFRAME");
 if (ltiframe)
    ltiframe.enable = !disabled;
 

 document.forms[0]['NAV_GOFWD'].disabled =  disabled;	

 var firstInput = null;
 for (var i=0;i<document.forms[0].elements.length;i++)
 { 
        var elem = document.forms[0].elements[i];

	if (elem.type == 'checkbox' || elem.type == 'radio' || elem.type == 'textarea' || elem.type == 'text' || 
	    (elem.type == 'button' && elem.name != 'NAV_GOBACK'  && elem.name != 'NAV_BROWSENEXT' && elem.name != 'BtnShowRosterTreeView'))
	{				
		elem.disabled = disabled;			
		
		if (elem.type == 'text' && !firstInput && !disabled)
			firstInput = elem;
	}
 }

 if(!disabled) 
    for (var i=0;i<document.forms[0].elements.length;i++)
    { 
        var elem = document.forms[0].elements[i];

	if (elem.type == 'checkbox')
	{		

		if (elem.checked)
		{
			ExclusiveChoiceClick(elem.name);
                }
	}
    }

 if (document.forms[0]['SCREEN'] && document.forms[0]['SCREEN'].value == '1')
 for (var i=0;i<document.forms[0].elements.length;i++)
 { 
        var elem = document.forms[0].elements[i];

	if ((elem.type == 'radio' || elem.type == 'checkbox') && elem.checked)
	{
	   elem.click();
	   if (elem.type == 'checkbox')
		 elem.click();
		
        }

 }

 if (firstInput && !firstInput.disabled)
 {
    firstInput.focus(); 
    firstInput.select();
 }
}


function setBrowseMode(value)
{
 document.forms[0]['BROWSEMODE'].value = value;

 var btnShowRosterTreeView = document.getElementById("BtnShowRosterTreeView");
 if (btnShowRosterTreeView != null)
 {
   btnShowRosterTreeView.disabled = (value == 0);
 }
 var overlayDiv = document.getElementById("OverlayDiv");
 if (overlayDiv != null)
 {
   document.body.removeChild(overlayDiv);
 }

 if (value == 0 )
 {
    if (FindElementByName('GOTOQ'))
    {
        FindElementByName('GOTOQ').disabled = true;
        document.getElementById('NAV_GOTOQ').disabled = true;
    }

    FindElementByName('NAV_QUIT').disabled = true;
    
    if (document.getElementById('NAV_GOBACK'))
       document.getElementById('NAV_GOBACK').disabled = true;

    if (document.getElementById('NAV_BROWSENEXT'))
       document.getElementById('NAV_BROWSENEXT').disabled = true;    

 }
 else
 {
   if (FindElementByName('GOTOQ'))	
   {
        FindElementByName('GOTOQ').disabled = false;
        document.getElementById('NAV_GOTOQ').disabled = false;
   }
   FindElementByName('NAV_QUIT').disabled = false;
   
   if (document.getElementById('NAV_GOBACK'))
      document.getElementById('NAV_GOBACK').disabled = false;

   if (document.getElementById('NAV_BROWSENEXT'))
      document.getElementById('NAV_BROWSENEXT').disabled = false;
 }

 setInputControlsState(value == 1);

	if (FindElementByName('GOTOQ') && !FindElementByName('GOTOQ').disabled)
	{
		FindElementByName('GOTOQ').focus();  
	}
	else
	{
		focusFirstControl();
	}
   
 if (value == 0 && self.OpenAgendaExtension)
	self.OpenAgendaExtension();  
}

function getBrowseMode()
{   
   return document.forms[0]['BROWSEMODE'].value;
}

function getQuestionMaxAnswer(question)
{
   if (document.forms[0][question+':MAXANSWER']==null)
   return null;
   else	
   return document.forms[0][question+':MAXANSWER'].value; 
}

function getAnswerField(question)
{ 	
 var result = null;
 var maxAnswer = getQuestionMaxAnswer(question);
 if (maxAnswer == null)		
	return null;
 for (var i=1;i<=maxAnswer;i++)
 {
	result = document.forms[0][question+':ANSWER:' + i];
	if (result != null && ((result.value == '') || (result.value == ' '))) // In Design, a value of ' ' is possible
		return result;   
 }
  
 return document.forms[0][question+':ANSWER:' + maxAnswer]; 
}

function getQuestionCodeWidth(question)
{
   return document.forms[0][question+':CODEWIDTH'].value; 
}


function UpdateOtherCheckboxesAvailablility(question) {
  var maxAnswer = getQuestionMaxAnswer(question);
  var elems = document.forms[0].elements;
  var isMaxAnswerReached = false;
  var nbSelectedChoices = 0;

  for (var i = 0; i < elems.length; i++) {
    if (elems[i].type == 'radio' || elems[i].type == 'checkbox') {
      if ((getInputQuestion(elems[i]) == question) && (elems[i].checked)) {
        nbSelectedChoices++;
        if (nbSelectedChoices == maxAnswer) {
          isMaxAnswerReached = true;
          break;
        }
      }
    }
  } // for

  if (isMaxAnswerReached) {
    // Disable all unselected choices
    for (var j = 0; j < elems.length; j++) {
      if (elems[j].type == 'radio' || elems[j].type == 'checkbox') {
        if ((getInputQuestion(elems[j]) == question) && (!elems[j].checked)) {
          elems[j].disabled = true;
        }
      }
    } // for
  }
  else if (nbSelectedChoices == maxAnswer - 1) {
    // Re-enable unselected choices
    for (var j = 0; j < elems.length; j++) {
      if (elems[j].type == 'radio' || elems[j].type == 'checkbox') {
        if ((getInputQuestion(elems[j]) == question) && (!elems[j].checked)) {
          if (!elems[j].isExclusive)
          {
            elems[j].disabled = false;
          }
        }
      }
    } // for
  }
}

function UncheckAllFields(question)
{
  var elems = document.forms[0].elements;

  for (var i = 0; i < elems.length; i++) {
    if (elems[i].type == 'radio' || elems[i].type == 'checkbox') {
      if ((getInputQuestion(elems[i]) == question) && (elems[i].checked)) {
          elems[i].checked = false
      }
    }
  }
 }

function ClearDateFields(question)
{
  var elems = document.forms[0].elements;
  for (var i = 0; i < elems.length; i++) {
    var s = elems[i].name
    if (s == question + '_YEAR'||s == question + '_MONTH' ||s == question + '_DAY' || s == 'MASK_' + question) 
    {elems[i].value = ''}
  }
 }

function DateFieldOnChange(question)
{UncheckAllFields (question) }

function MaskFieldOnChange(question)
{UncheckAllFields (question) }

function updateAnswerField(question, value, multiple)
{
  ClearDateFields(question);
  if (getAnswerField(question) == null) return;

   var answer = '';
   if (multiple)
   {
       UpdateOtherCheckboxesAvailablility(question);  

       var maxAnswer = getQuestionMaxAnswer(question);
       	
       var previous = null;	
       for (var i=1;i<=maxAnswer;i++)
       {
 	        var field = document.forms[0][question+':ANSWER:' + i]; 
                    
          	var customdata = document.forms[0][question+':CUSTOMDATA:' + i]; 
          	var datalabel = document.forms[0][question+':DATALABEL:' + i]; 
       
    
		if (field.value != null && value != null && field.value.toUpperCase() == value.toUpperCase() && !valueIschecked(question,value))
		{			   
			field.value = '';
			if(customdata)
			{
				customdata.value = '';
				datalabel = '';	                  
			}
		}
	       
		if (previous != null)
		{       
	  		var prevcustomdata = document.forms[0][question+':CUSTOMDATA:' + getInputIndex(previous)]; 
          		var prevdatalabel = document.forms[0][question+':DATALABEL:' + getInputIndex(previous)]; 	 

	  		previous.value = field.value;         
			if(prevcustomdata)
			{
				prevcustomdata.value = customdata.value;
				prevdatalabel.value = datalabel.value;
			}
                            		    
	                    
			field.value = '';          
		}
	              
		if (field.value == '')
			previous = field;		
                      
       }               
       
              
       if (valueIschecked(question,value))
       {
         var input = getAnswerField(question);
                  
         checkValue(question,input.value,false);
		 	input.value = value;		   	 	
	}
   }
   else   
{
      getAnswerField(question).value = value;		   
}
   
 
}

function deleteToken(token,s)
{
	var tLen = token.length;
	var result = '';
	for (var i=0;i<s.length;i+=tLen)
	{
	   if (token != s.substr(i,tLen))
	   {
		result += s.substr(i,tLen);		
	   }
	}
	return result;
};	

function tokenInStr(token,s)
{
	var sLen = s.length;
	var tLen = token.length;

	for (var i=0;i<sLen;i+=tLen)
	{
	   if (token == s.substr(i,tLen))
	   {
		return true;		
	   }
	}
        

	return false;
};	

function checkValue(question,value,checked)
{	
	if (value=='') 
	   return;
	   
	var elems = document.forms[0].elements; 

	for (var i=0;i<elems.length;i++)
	{
		if (elems[i].type == 'radio' || elems[i].type == 'checkbox')
		   if (getInputQuestion(elems[i]) == question && elems[i].value != null && value != null && elems[i].value.toUpperCase() == value.toUpperCase())		                           
		   {
            	    elems[i].checked = checked;
			   return;
		   }		
	};
	
};

function valueIsInputed(question,value)
{
   var maxAnswer = getQuestionMaxAnswer(question);      	
       
   for (var i=1;i<=maxAnswer;i++)
   {
	var field = document.forms[0][question+':ANSWER:' + i]; 

	if (field.value != null && value != null && field.value.toUpperCase() == value.toUpperCase())
		return true;			
   }               
   
   return false;
}

function valueIschecked(question,value)
{	
	var elems = document.forms[0].elements; 

	for (var i=0;i<elems.length;i++)
	{
		if (elems[i].type == 'radio' || elems[i].type == 'checkbox')
		   if (getInputQuestion(elems[i]) == question)		                           
               if ((elems[i].checked) && (elems[i].value != null && value != null && elems[i].value.toUpperCase() == value.toUpperCase())) 
						return true;
		
	};
	
	return false;
};

function getInputIndex (input)
{
	var index =  input.name.lastIndexOf(':');			
	return input.name.substr(index+1,input.name.length - index)
}

function getInputQuestion (input)
{
	var index =  input.name.indexOf(':');

        if (index < 0)
        return input.name;
        else
	return input.name.substr(0,index)
	
}


function currentQuestionIsFirst()
{
   var dropdown = FindElementByName('GOTOQ');
	var alias = FindElementByName('QLABEL').value;
	
	if(dropdown != null && dropdown[dropdown.length-1].value != null )
	{
		return (dropdown && dropdown[dropdown.length-1].value == alias);
	}
	else
	{
		return true;
	}
}

function currentQuestionIsLast()
{
   //var alias = FindElementByName('QLABEL').value;   
   //return (FindElementByName('GOTOQ') && FindElementByName('GOTOQ').value == alias);
   
	var dropdown = FindElementByName('GOTOQ');
	var alias = FindElementByName('QLABEL').value; // intro		
	if(dropdown != null && dropdown[0].value != null && alias != dropdown[0].value )
	{
		return (dropdown && dropdown.value == dropdown[0].value);
	}
	else
	{
		return true;
	}
}

function getNextInput(input)
{   
   var index = getInputIndex(input);
   index++;
   
   var question = getInputQuestion(input);
        
   return document.forms[0][question+':ANSWER:' + (index)]   
}

function shiftInputLeft(input)
{
	var question = getInputQuestion(input);

	var current = input;
	var next = getNextInput(input);
	while (next != null)
	{

          var currentcustomdata = document.forms[0][question+':CUSTOMDATA:' + getInputIndex(current)]; 
          var currentdatalabel = document.forms[0][question+':DATALABEL:' + getInputIndex(current)]; 
	  var nextcustomdata = document.forms[0][question+':CUSTOMDATA:' + getInputIndex(next)]; 
          var nextdatalabel = document.forms[0][question+':DATALABEL:' + getInputIndex(next)]; 

	
          if (currentcustomdata)
	  {
              currentcustomdata.value = nextcustomdata.value;
	      currentdatalabel.value = nextdatalabel.value;	
          }	
	
	  current.value = next.value;
	  next.value = '';
          if (nextcustomdata)
	  {
              nextcustomdata.value = '';
	      nextdatalabel.value = '';	
          }

	  current = next;
	  next = getNextInput(current);               
	}
	
}

function FocusChoice(question,value,checkchoice)
{
   var elems = document.forms[0].elements;       
   var firstChoice = null;
	
   for (var i=0;i<elems.length;i++)
   {
		if (elems[i].type == 'radio' || elems[i].type == 'checkbox')
                {
                   if (firstChoice == null) 
                     firstChoice = elems[i];
		   if ((getInputQuestion(elems[i]) == question || question =='') && (elems[i].value != null && value != null && elems[i].value.toUpperCase() == value.toUpperCase() || value==''))
                   {	        
		       if (elems[i].type == 'radio' && question != '')
                       {
                       	if(checkchoice)
                       	{
			   elems[i].checked = true;	               
			   elems[i].click();
			}		   
                         
                       }
		       if (!elems[i].disabled)	
                          elems[i].focus();  

                       return;
                   }  
 
                }
	};

   if (firstChoice != null && !firstChoice.disabled)
      firstChoice.focus();
}

function AnswerKeyUp(input, e)
{	
	if(window.event)
	{
		var keycode = window.event.keyCode;
	}
	else
	{
		var keycode = e.which;
	}
	//Exit if TAB or Escape or Shift or delete or arrows
	if (keycode == 9 || keycode == 27 || keycode == 16 || (keycode >=33 && keycode<=37) || keycode == 39)
		return;

	if(input.readOnly && (keycode == 46 || keycode == 8))		
        {
	    input.value = '';  
        }

		
	var question = getInputQuestion(input)

        if (keycode == 38 || keycode == 40)
        {
           FocusChoice(question,input.value,true);
           return;
        }

	var codeWidth = getQuestionCodeWidth(question);
	
	var answer = getAnswerField(question).value;

	var elems = document.forms[0].elements; 



        
   if (document.forms[0][question+':' + input.value] != null && document.forms[0][question+':' + input.value].disabled)
      input.value = '';
   
	for (var i=0;i<elems.length;i++)
	{
		if (elems[i].type == 'radio' || elems[i].type == 'checkbox')
		   if (getInputQuestion(elems[i]) == question)
                   {		
			   var checked = elems[i].checked;
	   	   		  	
			   elems[i].checked = valueIsInputed(question,elems[i].value);			                           
                           
                           if (elems[i].checked != checked) 
                              ExclusiveChoiceClick(getInputQuestion(elems[i])+ ':'+elems[i].value);                             
                   }  
	};
	
	if(input.value == '')
	{
		shiftInputLeft(input);
                input.select();
	}
	else
	if (input.value.length == codeWidth)
	{
		var nextInput = getNextInput(input);
		if (nextInput != null && !nextInput.disabled)
		{	
			nextInput.focus();	                        
		}
	}
     
}

function focusFirstControl()
{
	var _browserMode = getBrowseMode();
	if(_browserMode == 0 )
	{
		var input = getFirstInputControl();	
		if(input)
		{
		  if (!input.disabled) 
      {
			  // If in Design, make sur the answer field selection is not empty
			  if ((input.value == '') && (document.forms[0]['PROJECT'].value == '0')) {
			    input.value = ' ';
			  }
				input.focus();
				input.select();			
			}
		}	
		else
		{		
			FocusChoice('','',false);
		}
	}
	else
	{		
		if(FindElementByName('GOTOQ'))
		{			
			FindElementByName('GOTOQ').focus();
		}
		else if(FindElementByName('NAV_QUIT'))
		{
			FindElementByName('NAV_QUIT').focus();
		}		
	}
}

function GetEventSource(e)
{
   if (window.event) {return window.event.srcElement;}
   else if (e.srcElement) {return e.srcElement;}
   else if (e.target) {return e.target;}
   else return null;
}

function FindElementByName(name)
{
	var ctlArray = document.getElementsByName(name);
	if (ctlArray != null && ctlArray.length > 0)
	{
		return ctlArray[0];
	}
	else
	{
		return null;
	}
}

function CancelKeyEvent(e)
{
    if (window.event)
    {
        window.event.cancelBubble = true;
        window.event.keyCode = 0;
        window.event.returnValue = false;
    }

    if (e)
    {
        e.cancelBubble = true;        
        e.returnValue = false;
        if (e.preventDefault) 
        {	
            e.preventDefault();
        } 
    }

    return false;
}

function SubmitOnEnter(e)
{
    var source = GetEventSource(e);
    if (!source || source.type != "textarea")
    {
        var element = document.getElementsByName("INTWEB")[0];
        var nextButton = document.getElementsByName("NAV_GOFWD")[0];


        var canSubmitRunningTotal = true;
        if (!(typeof ValidateBeforeSubmit_1 === 'undefined'))
        {
            var previousNextButtonClickedValue = document.forms[0]['NEXTBUTTONCLICKED'].value;
            document.forms[0]['NEXTBUTTONCLICKED'].value = '1'; // The running total validation scripts relies on this...
            var previousAlert = window.alert;
            window.alert = function() {}; // Prevent ValidateBeforeSubmit_1() to generate an alert here. It will be generated in the onsubmit handler of the form
            canSubmitRunningTotal = ValidateBeforeSubmit_1();
            window.alert = previousAlert; // restore the original alert
            document.forms[0]['NEXTBUTTONCLICKED'].value = previousNextButtonClickedValue; // Restore the previous value
            console.warn('canSubmitRunningTotal (final) = ' + canSubmitRunningTotal);
        }


        if (element && (!nextButton.disabled) && canSubmitRunningTotal)
        {
            CancelKeyEvent(e);
            element.submit();
            nextButton.disabled = true;
        }
    }
}


function GetTopLeftOffset(node)
{ 
    var x = 0; 
    var y = 0; 
    while( node && !isNaN( node.offsetLeft ) && !isNaN( node.offsetTop ) )
    { 
      x += node.offsetLeft - node.scrollLeft; 
      y += node.offsetTop - node.scrollTop; 
      node = node.offsetParent; 
    } 
    return {top: y, left: x}; 
} 